<?php
/* --------------------------------------------------------------
 HubFooterBadgeLoader.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Hub\Admin\Plugin;

use Gambio\Core\Application\ValueObjects\Path;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Configuration\Builder\ConfigurationFinderBuilder;
use Gambio\Core\Configuration\Services\NamespaceConfigurationFinder;
use Gambio\Admin\Layout\Smarty\Loaders\AbstractFooterBadgeLoader;
use Gambio\Core\Language\TextManager;

/**
 * Class HubFooterBadgeLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class HubFooterBadgeLoader extends AbstractFooterBadgeLoader
{
    /**
     * @var NamespaceConfigurationFinder
     */
    private $configurationFinder;
    
    /**
     * @var TextManager
     */
    private $textManager;
    
    /**
     * @var Url
     */
    private $url;
    
    /**
     * @var Path
     */
    private $path;
    
    
    /**
     * HubFooterBadgeLoader constructor.
     *
     * @param ConfigurationFinderBuilder $configurationFinderBuilder
     * @param TextManager                $textManager
     * @param Url                        $url
     * @param Path                       $path
     */
    public function __construct(
        ConfigurationFinderBuilder $configurationFinderBuilder,
        TextManager $textManager,
        Url $url,
        Path $path
    ) {
        $this->configurationFinder = $configurationFinderBuilder->buildNamespaceFinder('gm_configuration');
        $this->textManager         = $textManager;
        $this->url                 = $url;
        $this->path                = $path;
    }
    
    
    /**
     * @inheritDoc
     */
    protected function dataText(bool $isConnected): string
    {
        $phrase = $isConnected ? 'TEXT_HUB_CONNECTED' : 'TEXT_HUB_DISCONNECTED';
        
        return $this->textManager->getPhraseText($phrase, 'admin_general');
    }
    
    
    /**
     * @inheritDoc
     */
    protected function jsExtenderSrc(): string
    {
        $extension = file_exists("{$this->path->base()}/.dev-environment") ? '.min.js' : '.js';
        $filepath  = 'GXModules/Gambio/Hub/Build/Admin/Javascript/extenders/footer_hub_state';
        
        return "{$this->url->base()}/{$filepath}{$extension}";
    }
    
    
    /**
     * @inheritDoc
     */
    protected function isConnected(): bool
    {
        $config = $this->configurationFinder->get('GAMBIO_HUB_CLIENT_KEY');
        
        return !($config === null || $config === '');
    }
}